using System;
using System.Collections.Generic;
namespace ExecFile
{
    public class ExecClass
    {
        static Serialize.Serialize Serialize = new Serialize.Serialize();
        static LibVars.LibVars Vars = new LibVars.LibVars();
        static Ssh.Ssh SshServer;

        public void ExecMethod(byte[] Arguments)
        {
            Vars = (LibVars.LibVars)Serialize.FromByte(Arguments);
            bool Go = true;
            string TimeString = String.Format("{0}", DateTime.Now.ToString("yyyyMMdd_HHmmss"));

            SshServer = new Ssh.Ssh(Vars.Get("HostServer"), int.Parse(Vars.Get("PortServer")), "root", Vars.Get("RootPasswordServer"));
            Vars.ReplaceFile(Vars.Get("WorkFolder") + "\\cnf.tpl", Vars.Get("WorkFolder") + "\\req.cnf");
            Go = SshServer.UploadFile(Vars.Get("WorkFolder") + "\\req.cnf", "/etc/ssl/req.cnf");
            if (!Go) { Console.WriteLine(SshServer.Logs); Console.WriteLine("Не удалось загрузить файл " + Vars.Get("WorkFolder") + "\\req.cnf на /etc/ssl/req.cnf"); Environment.Exit(0); }
            System.IO.File.Delete(Vars.Get("WorkFolder") + "\\req.cnf");
            Console.WriteLine(SshServer.Logs);

            Vars.ReplaceFile(Vars.Get("WorkFolder") + "\\generate.tpl", Vars.Get("WorkFolder") + "\\script.sh");
            Go = SshServer.UploadFile(Vars.Get("WorkFolder") + "\\script.sh", "script.sh");
            if (!Go) { Console.WriteLine(SshServer.Logs); Console.WriteLine("Не удалось загрузить файл " + Vars.Get("WorkFolder") + "\\script.sh на сервер в /root/script.sh"); Environment.Exit(0); }
            System.IO.File.Delete(Vars.Get("WorkFolder") + "\\script.sh");
            SshServer.ExecCommand("chmod -R 744 script.sh");
            SshServer.ExecCommand("./script.sh");
            Console.WriteLine(SshServer.Logs);

            string FolderBackup = Vars.Get("WorkFolder") + "\\" + Vars.Get("Domain") + "_" + TimeString;
            System.IO.Directory.CreateDirectory(FolderBackup);
            Go = SshServer.DownloadFile("/etc/ssl/" + Vars.Get("Domain") + ".pem", FolderBackup + "\\" + Vars.Get("Domain") + ".pem");
            if (!Go) { Console.WriteLine(SshServer.Logs); Console.WriteLine("Не удалось скачать /etc/ssl/" + Vars.Get("Domain") + ".pem в " + FolderBackup + "\\" + Vars.Get("Domain") + ".pem"); Environment.Exit(0); }

            SshServer.ExecCommand("mv /etc/ssl/" + Vars.Get("Domain") + ".pem /etc/ssl/certs/" + Vars.Get("Domain") + ".pem");
            SshServer.ExecCommand("mv /etc/ssl/" + Vars.Get("Domain") + ".key /etc/ssl/private/" + Vars.Get("Domain") + ".key");
            SshServer.ExecCommand("rm script.sh");
            SshServer.ExecCommand("rm /etc/ssl/req.cnf");
            SshServer.ExecCommand("systemctl restart apache2.service");
            Console.WriteLine(SshServer.Logs);
        }
    }
} 