using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
namespace ExecFile
{
    public class ExecClass
    {
        static Serialize.Serialize Serialize = new Serialize.Serialize();
        static LibVars.LibVars Vars = new LibVars.LibVars();
        static Ssh.Ssh SshServer;

        public void ExecMethod(byte[] Arguments)
        {
            Vars = (LibVars.LibVars)Serialize.FromByte(Arguments);

            string Config = System.Text.RegularExpressions.Regex.Replace(Vars.Get("Domain"), @"[^\w\d]", "_");
            Config = System.Text.RegularExpressions.Regex.Replace(Config, "_{2,}", "_");
            Vars.Set("ConfigSite", Config);
            Config = Config+"-ssl.conf";
            Vars.ReplaceFile(Vars.Get("WorkFolder") + "\\sites-available.tpl", Vars.Get("WorkFolder") + "\\" + Config);
            
            SshServer = new Ssh.Ssh(Vars.Get("HostServer"), int.Parse(Vars.Get("PortServer")), "root", Vars.Get("RootPasswordServer"));
            int f = SshServer.ExistPath("/etc/apache2/sites-available/" + Config);
            if (f < 1 && f > 2) { Console.WriteLine(SshServer.Logs); Console.WriteLine("Ошибка!\nПуть: " + "\"/etc/apache2/sites-available/" + Config + "\" существует и это не файл."); Environment.Exit(0); } 
            if (f == 2) {
                Console.WriteLine("Файл: " + "\"/etc/apache2/sites-available/" + Config + "\" существует.");
                SshServer.ExecCommand("a2dissite " + Config);
                SshServer.ExecCommand("rm " + "/etc/apache2/sites-available/" + Config);
            }

            SshServer.UploadFile(Vars.Get("WorkFolder") + "\\" + Config, "/etc/apache2/sites-available/" + Config);
            System.IO.File.Delete(Vars.Get("WorkFolder") + "\\" + Config);
            SshServer.ExecCommand("a2ensite " + Config);
            SshServer.ExecCommand("systemctl restart apache2.service");
            Console.WriteLine(SshServer.Logs);
            
        }
    }
} 